package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;

public class binaryForwardCheckAll extends consistencyAlgorithm {

	public binaryForwardCheckAll(constraintProblem newProblem, sudokuBoard board) {
		super(newProblem, board);
	}

	
	public boolean runAlgorithm() throws InterruptedException
	{
		variableReductions = new LinkedList();
		parentProblem.registerDomainReductionListener(variableReductions);

		Iterator i = ((Collection)parentProblem.getAllVariables()).iterator();
		while(i.hasNext())
		{
			problemVariable currentVariable = (problemVariable)i.next();

			consistencyAlgorithm myForwardCheckOnVariable = new binaryForwardCheckOnVariable(parentProblem, ourBoard, currentVariable);
			if(!myForwardCheckOnVariable.runAlgorithm())
			{
				//if there was an error set this to have an error and get the constraint that caused it.
				this.setEncounteredError(true);
				this.setBrokenConstraint(myForwardCheckOnVariable.getBrokenConstraint());
				parentProblem.unregisterDomainReductionList(variableReductions);
				return false;
			}
		}
		
		parentProblem.unregisterDomainReductionList(variableReductions);
		this.setBrokenConstraint(null);
		this.setEncounteredError(false);
		return true;
	}
}
